/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.hardware;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.comm.VirtualDeviceDataTransfer;
import DE.siemens.ad.logo.model.DrawingProperties;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.MemoryUsageTable;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.ParameterItemTableLogo6;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AmplifierBlock;
import DE.siemens.ad.logo.model.block.AnalogComparatorBlock;
import DE.siemens.ad.logo.model.block.AnalogDeltaTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogMathsBlock;
import DE.siemens.ad.logo.model.block.AnalogMuxBlock;
import DE.siemens.ad.logo.model.block.AnalogTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogWatchdogBlock;
import DE.siemens.ad.logo.model.block.AndBlock;
import DE.siemens.ad.logo.model.block.AsymPulseGeneratorBlock;
import DE.siemens.ad.logo.model.block.ClockBlock;
import DE.siemens.ad.logo.model.block.ComfortSwitchBlock;
import DE.siemens.ad.logo.model.block.CounterBlock;
import DE.siemens.ad.logo.model.block.HoursCounterBlock;
import DE.siemens.ad.logo.model.block.LatchingRelayBlock;
import DE.siemens.ad.logo.model.block.MathDetectionBlock;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.model.block.NandBlock;
import DE.siemens.ad.logo.model.block.NorBlock;
import DE.siemens.ad.logo.model.block.NotBlock;
import DE.siemens.ad.logo.model.block.OffDelayBlock;
import DE.siemens.ad.logo.model.block.OnDelayBlock;
import DE.siemens.ad.logo.model.block.OnOffDelayBlock;
import DE.siemens.ad.logo.model.block.OrBlock;
import DE.siemens.ad.logo.model.block.PIDBlock;
import DE.siemens.ad.logo.model.block.PWMBlock;
import DE.siemens.ad.logo.model.block.PecAndBlock;
import DE.siemens.ad.logo.model.block.PecNandBlock;
import DE.siemens.ad.logo.model.block.PulseRelayBlock;
import DE.siemens.ad.logo.model.block.RampControlBlock;
import DE.siemens.ad.logo.model.block.RandomBlock;
import DE.siemens.ad.logo.model.block.RetentiveOnDelayBlock;
import DE.siemens.ad.logo.model.block.ShiftRegisterBlock;
import DE.siemens.ad.logo.model.block.SoftkeyBlock;
import DE.siemens.ad.logo.model.block.StairsSwitchBlock;
import DE.siemens.ad.logo.model.block.TriggerBlock;
import DE.siemens.ad.logo.model.block.WipingRelayBlock;
import DE.siemens.ad.logo.model.block.WipingRelayPECBlock;
import DE.siemens.ad.logo.model.block.XorBlock;
import DE.siemens.ad.logo.model.block.YearClockBlock;
import DE.siemens.ad.logo.model.hardware.Logo5;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromHardware;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo6;
import DE.siemens.ad.logo.model.visitor.build.CompilerToHardware;
import DE.siemens.ad.logo.model.visitor.build.CompilerToLogo6;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo6;
import DE.siemens.ad.logo.util.AnchorMemory16;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.Memory16;
import DE.siemens.ad.logo.util.MessageMemoryRTF;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.ProgramMemory16;
import DE.siemens.ad.logo.util.Util;
import java.util.Dictionary;
import java.util.Hashtable;

public class Logo6
extends Logo5 {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected static int ADR_AI_POS = 17322;
    protected static int ADR_AQ_TYPE = 17323;
    protected static int ADR_UPLOADING_FINISHED_FLAG = 16896;
    private volatile transient boolean fNoNeedMessageInfo = false;
    private transient boolean fEEPromCleared = false;
    private transient int fAINumberBeforeDownload;
    private transient boolean fChangeAINumberSetting = false;

    public int getOrder() {
        return 1300;
    }

    public boolean isNeedMessageInfo() {
        return !this.fNoNeedMessageInfo;
    }

    public void setNeedmessageInfo(boolean needed) {
        this.fNoNeedMessageInfo = !needed;
    }

    protected static Dictionary getSystemInfo() {
        Hashtable<String, Object> dict = new Hashtable<String, Object>(20);
        dict.put("knownBlocks", Logo6.getBlockNamesArray());
        TimeUnit[] availableTimeUnits = new TimeUnit[]{new Hours(), new Minutes(), new HighResolutionSeconds()};
        dict.put("availableTimeUnits", availableTimeUnits);
        int[] iArr = new int[]{200, Integer.MAX_VALUE, 250, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 24, 16, 0, 0, 27, 8, 50, 2, 3800, 100, 6, 4, 1, 8, 16, 4};
        dict.put("maxValues", iArr);
        dict.put("blockMemoryTable", new BlockMemoryUsage());
        dict.put("blockActualParameterMemory", new BlockActualMemoryUsage());
        dict.put("blockREMMemoryTable", new BlockREMMemoryUsage());
        dict.put("parameterItemTable", new ParameterItemTableLogo6());
        Logo6.addPropertyItems(dict);
        Logo6.addSupportItems(dict);
        return dict;
    }

    protected static String[][] getBlockNamesArray() {
        String[][] sArr = new String[][]{{"Constant", "Input", "KeyInput", "TDFunctionKeyInput", "Output", "Marker", "AnalogMarker", "High", "Low", "AnalogInput", "AnalogOutput", "ShiftRegisterInput", "VirtualOutput"}, {"Base", "And", "Or", "Not", "Xor", "Nand", "Nor", "PecAnd", "PecNand"}, {"Special", "OnDelay", "OffDelay", "PulseRelay", "Clock", "LatchingRelay", "RetentiveOnDelay", "Counter", "HoursCounter", "WipingRelay", "Trigger", "AsymPulseGenerator", "YearClock", "OnOffDelay", "Random", "StairsSwitch", "ComfortSwitch", "WipingRelayPEC", "Message", "AnalogTrigger", "AnalogComparator", "Amplifier", "AnalogWatchdog", "AnalogDeltaTrigger", "ShiftRegister", "Softkey", "PID", "AnalogMux", "RampControl", "AnalogMaths", "MathDetection", "PWM"}};
        return sArr;
    }

    protected static void addPropertyItems(Hashtable dict) {
        Logo5.addPropertyItems(dict);
        dict.put("msgPrioCount", new Integer(128));
        dict.put("RTFMaxMessageParameterItem", 8);
        dict.put("RTFMaxDataTimeItem", 4);
        dict.put("RTFMaxBarGraphItem", 4);
        dict.put("RTFMaxAIFilterItem", 2);
        dict.put("RTFMaxIOStatusItem", 4);
        dict.put("RTFMaxIOStatusItemTotal", 20);
        dict.put("TypeInStatusName", new int[]{6, 7});
    }

    protected static void addSupportItems(Hashtable dict) {
        Logo5.addSupportItems(dict);
        dict.put("supportClearUserProgram", Boolean.TRUE);
        dict.put("supportShowFWVersion", Boolean.TRUE);
        dict.put("supportSetPowerOnScreen", Boolean.TRUE);
        dict.put("counter_startValue", Boolean.TRUE);
        dict.put("pulseClock", Boolean.TRUE);
        dict.put("yearRangePulseYearClock", Boolean.TRUE);
        dict.put("hoursCounterTimebase", Boolean.TRUE);
        dict.put("AddressMode_Bit_32", Boolean.TRUE);
        dict.put("Start Screen", Boolean.TRUE);
        dict.put("aqType", Boolean.TRUE);
        dict.put("analogWatchdogWithTwoDelta", Boolean.TRUE);
        dict.put("analogWatchdogWithRetentivity", Boolean.TRUE);
        dict.put("Analog_4_or_2_config", Boolean.TRUE);
        dict.put("supportAsiaLanguage", Boolean.TRUE);
        dict.put("StairsSwitch_ref", Boolean.TRUE);
        dict.put("WipingRelay_ref", Boolean.TRUE);
        dict.put("WipingRelayPEC_ref", Boolean.TRUE);
        dict.put("AnalogComparator_ref", Boolean.TRUE);
        dict.put("AnalogWatchdog_ref", Boolean.TRUE);
        dict.put("AnalogTrigger_ref", Boolean.TRUE);
        dict.put("Time2Protection_ref", Boolean.TRUE);
        dict.put("HoursCounter_ref", Boolean.TRUE);
        dict.put("Trigger_ref", Boolean.TRUE);
        dict.put("NeedMessageNumber", Boolean.TRUE);
        dict.put("newRuleUsaDst", Boolean.TRUE);
    }

    protected int getOpcodeSF(String name) throws IllegalArgumentException {
        if (name.equals("AnalogMaths")) {
            return 68;
        }
        if (name.equals("PWM")) {
            return 59;
        }
        if (name.equals("MathDetection")) {
            return 60;
        }
        return super.getOpcodeSF(name);
    }

    public int getID() {
        return 67;
    }

    public int getFirmwareID() {
        return 608;
    }

    public int getNumberOfTransferBytes() {
        return 13464;
    }

    protected int getActualDataOffset(int opcode) {
        switch (opcode) {
            case 59: {
                return 19;
            }
            case 68: {
                return 18;
            }
            case 36: {
                return 18;
            }
            case 46: {
                return 9;
            }
            case 43: {
                return 20;
            }
            case 41: {
                return 19;
            }
            case 57: {
                return 15;
            }
            case 60: {
                return 11;
            }
        }
        return super.getActualDataOffset(opcode);
    }

    public CompilerFromHardware getCompilerFromHardware() {
        return new CompilerFromLogo6();
    }

    protected int getChecksum() {
        return super.getChecksum();
    }

    public CompilerToHardware getCompilerToHardware() {
        return new CompilerToLogo6();
    }

    public LinkerToLogo getLinkerToHardware() {
        return new LinkerToLogo6(this);
    }

    public Memory[] getMemories() {
        if (this.fMemories == null) {
            this.fMemories = new Memory[11];
            int nrOfBlocknames = this.getMaxResource(15);
            this.fMemories[0] = new Memory("BlocknamenTabelle", 1672, nrOfBlocknames, 1);
            this.fMemories[1] = new Memory("Blocknamen", 1800, nrOfBlocknames, 8);
            this.fMemories[2] = new MessageMemoryRTF("Message RTF", 2728);
            ((MessageMemoryRTF)this.fMemories[2]).setAllByteAtOnce(true);
            this.fMemories[3] = new Memory16("ProgOffsetTabelle", 12202, this.getMaxResource(0) + 10, 2);
            int PROG_START = 12746;
            this.fMemories[4] = new AnchorMemory16("Anker Q1...Qi", 12746, 2, 20, 48);
            this.fMemories[5] = new AnchorMemory16("Merker", 12786, 3, 20, 80);
            this.fMemories[6] = new AnchorMemory16("Analoganker", 12846, 1, 20, 144);
            this.fMemories[7] = new AnchorMemory16("Virtuelle Anker", 12866, 2, 20, 192);
            this.fMemories[8] = new AnchorMemory16("Reserviert", 12906, 1, 20, 0);
            this.fMemories[9] = new AnchorMemory16("Special Merker", 12926, 1, 20, 104);
            this.fMemories[10] = new ProgramMemory16("Program", 12946, this.getMaxResource(14), 1);
        }
        return this.fMemories;
    }

    public int getAdress(int name) {
        int ret;
        if (name == ADR_AI_POS) {
            ret = ADR_AI_POS;
        } else if (name == ADR_AQ_TYPE) {
            ret = ADR_AQ_TYPE;
        } else if (name == ADR_UPLOADING_FINISHED_FLAG) {
            ret = ADR_UPLOADING_FINISHED_FLAG;
        } else {
            ret = super.getAdress(name);
            if (name != ADR_START_SCREEN && ret >= 7936) {
                ret |= 0xFF0000;
            }
        }
        return ret;
    }

    public int calculateBlockNumber(int opcode) throws IllegalArgumentException {
        if (opcode >= 104 && opcode <= 106) {
            return opcode - 104 + 25;
        }
        if (opcode >= 164 && opcode <= 167) {
            return opcode - 164 + 1;
        }
        return super.calculateBlockNumber(opcode);
    }

    protected int getRealCOOpcode(String name, int blockNr) {
        if (name.equals("TDFunctionKeyInput")) {
            return 164 + blockNr;
        }
        return super.getRealCOOpcode(name, blockNr);
    }

    public void downloadProgram(DataTransfer dt, WiringDiagram wd) throws ExceptionAlreadyHandledException {
        boolean tryAgain;
        do {
            tryAgain = false;
            try {
                this.fAINumberBeforeDownload = dt.readByte(this.getAdress(ADR_AI_POS)) & 1;
                int aiPos = wd.getDrawingProperties().getAIPosition();
                if (this.fAINumberBeforeDownload != aiPos) {
                    LogoError dlg = new LogoError(null, "msg.datatransfer.differentAI", "Change AI settings?", 3, 3);
                    int dlgRet = dlg.display();
                    if (dlgRet == 2) {
                        this.fChangeAINumberSetting = true;
                        continue;
                    }
                    if (dlgRet == 3) {
                        this.fChangeAINumberSetting = false;
                        continue;
                    }
                    return;
                }
                this.fChangeAINumberSetting = false;
            }
            catch (TransmissionFailedException tfe) {
                tryAgain = LogoError.checkRepeatTransmission(tfe);
                if (tryAgain) continue;
                throw new ExceptionAlreadyHandledException();
            }
        } while (tryAgain);
        if (this.isSupportFastCommunication(dt)) {
            this.fEEPromCleared = false;
            try {
                this.fEEPromCleared = dt.sendCommand(32);
                if (this.fEEPromCleared) {
                    int byteCount = this.getByteCountToDownload();
                    dt.getProgressListener().setNote(Language.getString("msg.datatransfer.Clear", "Clear user program..."));
                    dt.waitUntilDeviceReady(this.getQueryTimeToClearEEProm(), 2, true);
                    dt.getProgressListener().setNote(Language.getString("msg.datatransfer", "Tranfering data..."));
                    dt.getProgressListener().setMaximum(byteCount);
                }
            }
            catch (Exception e) {
                this.fEEPromCleared = false;
            }
        }
        super.downloadProgram(dt, wd);
        if (this.fChangeAINumberSetting) {
            this.restartToApplyAIPosSetting(dt);
        }
    }

    protected int getQueryTimeToClearEEProm() {
        return 4;
    }

    protected void restartToApplyAIPosSetting(DataTransfer dt) {
        try {
            boolean needRestartBM = dt.sendCommand(34);
            if (needRestartBM) {
                Log.println(Language.getString("error.com.restartBM.getAck", "Device is restarted."));
            }
        }
        catch (TransmissionFailedException e) {
            new LogoError(null, "error.com.restartBM.getNoAck", "Apply the change of AI setting failed.", 0).display();
        }
    }

    private int getByteCountToDownload() {
        Memory[] memArr = this.getMemories();
        int progSize = 0;
        for (int i = 0; i < memArr.length; ++i) {
            progSize += memArr[i].getFastDownloadBytesCount();
        }
        return progSize;
    }

    public void downloadBlocks(DataTransfer dt) throws TransmissionFailedException {
        Memory[] memArr = this.getMemories();
        for (int i = 0; i < memArr.length; ++i) {
            long start = System.currentTimeMillis();
            memArr[i].download(dt, this.isUseFastDownload(dt));
            System.out.println(memArr[i].getName() + ": " + (System.currentTimeMillis() - start));
        }
    }

    public void uploadBlocks(DataTransfer dt) throws TransmissionFailedException {
        Memory[] memArr = this.getMemories();
        for (int i = 0; i < memArr.length; ++i) {
            if (memArr[i] instanceof MessageMemoryRTF) {
                if (this.isNeedMessageInfo()) {
                    ((MessageMemoryRTF)memArr[i]).upload(dt, this.isSupportFastCommunication(dt));
                    continue;
                }
                this.setNeedmessageInfo(true);
                continue;
            }
            memArr[i].upload(dt);
        }
    }

    public WiringDiagram uploadProgram(DataTransfer dt) throws ExceptionAlreadyHandledException, ProgramException {
        WiringDiagram ret = super.uploadProgram(dt);
        try {
            dt.writeCommandByte(this.getAdress(ADR_UPLOADING_FINISHED_FLAG), 0, this.getResetTimeout());
        }
        catch (TransmissionFailedException e) {
            System.err.println("Reset upload flag failed.");
        }
        return ret;
    }

    private boolean isUseFastDownload(DataTransfer dt) {
        return this.isSupportFastCommunication(dt) && this.fEEPromCleared;
    }

    private boolean isSupportFastCommunication(DataTransfer dt) {
        boolean useNewMethodForDownloadOrUpload = true;
        return !(dt instanceof VirtualDeviceDataTransfer);
    }

    protected void downloadAddtionalInfo(DataTransfer dt) throws TransmissionFailedException {
        super.downloadAddtionalInfo(dt);
        int aqType = 0;
        aqType = this.fDownloadedWiringDiagram.getDrawingProperties().getAQType2();
        aqType <<= 1;
        aqType |= this.fDownloadedWiringDiagram.getDrawingProperties().getAQType1();
        dt.writeByte(this.getAdress(ADR_AQ_TYPE), aqType &= 0xFF);
        if (this.fChangeAINumberSetting) {
            int aiPos = this.fDownloadedWiringDiagram.getDrawingProperties().getAIPosition();
            if (aiPos > 1) {
                System.err.println("Error AI setting.");
                aiPos &= 1;
            }
            dt.writeByte(this.getAdress(ADR_AI_POS), aiPos);
        }
    }

    protected DrawingProperties uploadAddtionalInfo(DataTransfer dt) throws TransmissionFailedException {
        DrawingProperties ret = super.uploadAddtionalInfo(dt);
        int aiPos = dt.readByte(this.getAdress(ADR_AI_POS));
        int aqType = dt.readByte(this.getAdress(ADR_AQ_TYPE));
        ret.setAIPosition(aiPos & 1);
        ret.setAQType1(aqType & 1);
        ret.setAQType2((aqType & 2) >> 1);
        return ret;
    }

    public int getResetTimeout() {
        return 5001;
    }

    public String uploadFunctionParameter(DataTransfer dt, int prgLine, int opcode, int parameterNr) throws UnsupportedOperationException, TransmissionFailedException {
        if (opcode == this.getOpcodeSF("HoursCounter") && parameterNr >= 4) {
            int[] ret = this.uploadFunctionParameter1(dt, prgLine, opcode, parameterNr, 4);
            if (ret.length == 4) {
                return String.valueOf(Util.makeSignedDoubleWord(ret[3], ret[2], ret[1], ret[0]));
            }
            return "0";
        }
        return super.uploadFunctionParameter(dt, prgLine, opcode, parameterNr);
    }

    static {
        cSystemInfoDict.put("Logo6", Logo6.getSystemInfo());
    }

    private static class BlockREMMemoryUsage
    extends MemoryUsageTable {
        private BlockREMMemoryUsage() {
        }

        protected void initializeTable() {
            this.put(OnDelayBlock.class, 3);
            this.put(OffDelayBlock.class, 3);
            this.put(PulseRelayBlock.class, 1);
            this.put(LatchingRelayBlock.class, 1);
            this.put(RetentiveOnDelayBlock.class, 3);
            this.put(HoursCounterBlock.class, 9);
            this.put(WipingRelayBlock.class, 3);
            this.put(CounterBlock.class, 5);
            this.put(AsymPulseGeneratorBlock.class, 3);
            this.put(OnOffDelayBlock.class, 3);
            this.put(StairsSwitchBlock.class, 3);
            this.put(ComfortSwitchBlock.class, 3);
            this.put(WipingRelayPECBlock.class, 4);
            this.put(SoftkeyBlock.class, 2);
            this.put(ShiftRegisterBlock.class, 1);
            this.put(PIDBlock.class, 2);
            this.put(AnalogMathsBlock.class, 2);
            this.put(AnalogWatchdogBlock.class, 3);
            this.put(MathDetectionBlock.class, 1);
        }
    }

    private static class BlockActualMemoryUsage
    extends MemoryUsageTable {
        private BlockActualMemoryUsage() {
        }

        protected void initializeTable() {
            this.put(OnDelayBlock.class, 4);
            this.put(OffDelayBlock.class, 6);
            this.put(PulseRelayBlock.class, 5);
            this.put(ClockBlock.class, 5);
            this.put(LatchingRelayBlock.class, 4);
            this.put(RetentiveOnDelayBlock.class, 6);
            this.put(HoursCounterBlock.class, 11);
            this.put(WipingRelayBlock.class, 4);
            this.put(CounterBlock.class, 10);
            this.put(TriggerBlock.class, 8);
            this.put(AsymPulseGeneratorBlock.class, 4);
            this.put(YearClockBlock.class, 2);
            this.put(OnOffDelayBlock.class, 6);
            this.put(RandomBlock.class, 6);
            this.put(StairsSwitchBlock.class, 4);
            this.put(ComfortSwitchBlock.class, 4);
            this.put(WipingRelayPECBlock.class, 6);
            this.put(MessageBlock.class, 2);
            this.put(AnalogTriggerBlock.class, 5);
            this.put(AnalogComparatorBlock.class, 11);
            this.put(SoftkeyBlock.class, 4);
            this.put(ShiftRegisterBlock.class, 2);
            this.put(AmplifierBlock.class, 4);
            this.put(AnalogWatchdogBlock.class, 9);
            this.put(AnalogDeltaTriggerBlock.class, 5);
            this.put(AnalogMuxBlock.class, 4);
            this.put(RampControlBlock.class, 14);
            this.put(PIDBlock.class, 15);
            this.put(AnalogMathsBlock.class, 4);
            this.put(PWMBlock.class, 7);
            this.put(MathDetectionBlock.class, 4);
        }
    }

    private static class BlockMemoryUsage
    extends MemoryUsageTable {
        private BlockMemoryUsage() {
        }

        protected void initializeTable() {
            this.put(AndBlock.class, 12);
            this.put(OrBlock.class, 12);
            this.put(NotBlock.class, 4);
            this.put(NandBlock.class, 12);
            this.put(NorBlock.class, 12);
            this.put(XorBlock.class, 8);
            this.put(PecAndBlock.class, 12);
            this.put(PecNandBlock.class, 12);
            this.put(OnDelayBlock.class, 8);
            this.put(OffDelayBlock.class, 12);
            this.put(PulseRelayBlock.class, 12);
            this.put(ClockBlock.class, 20);
            this.put(LatchingRelayBlock.class, 8);
            this.put(RetentiveOnDelayBlock.class, 12);
            this.put(HoursCounterBlock.class, 28);
            this.put(WipingRelayBlock.class, 8);
            this.put(CounterBlock.class, 28);
            this.put(TriggerBlock.class, 16);
            this.put(AsymPulseGeneratorBlock.class, 12);
            this.put(YearClockBlock.class, 12);
            this.put(OnOffDelayBlock.class, 12);
            this.put(RandomBlock.class, 12);
            this.put(StairsSwitchBlock.class, 12);
            this.put(ComfortSwitchBlock.class, 16);
            this.put(WipingRelayPECBlock.class, 16);
            this.put(MessageBlock.class, 8);
            this.put(AnalogTriggerBlock.class, 16);
            this.put(AnalogComparatorBlock.class, 24);
            this.put(SoftkeyBlock.class, 8);
            this.put(ShiftRegisterBlock.class, 12);
            this.put(AmplifierBlock.class, 12);
            this.put(AnalogWatchdogBlock.class, 20);
            this.put(AnalogDeltaTriggerBlock.class, 16);
            this.put(AnalogMuxBlock.class, 20);
            this.put(RampControlBlock.class, 36);
            this.put(PIDBlock.class, 40);
            this.put(AnalogMathsBlock.class, 20);
            this.put(PWMBlock.class, 24);
            this.put(MathDetectionBlock.class, 12);
        }
    }
}

